//: Playground - noun: a place where people can play

import UIKit

var str = "Hello, playground"

protocol Animal {
    var hitPoints: Int {get set}
}


extension Animal {
    mutating func takeHit(amount: Int) { hitPoints -= amount }
    func hitPointsRemaining() -> Int { return hitPoints }
    func isAlive() -> Bool { return hitPoints > 0 ? true : false }
}

protocol LandAnimal: Animal {
    var landAttack: Bool {get}
    var landMovement: Bool {get}
    
    func doLandAttack()
    func doLandMovement()
}

protocol SeaAnimal: Animal {
    var seaAttack: Bool {get}
    var seaMovement: Bool {get}
    
    func doSeaAttack()
    func doSeaMovement()
}

protocol AirAnimal: Animal {
    var airAttack: Bool {get}
    var airMovement: Bool {get}
    
    func doAirAttack()
    func doAirMovement()
}

struct Lion: LandAnimal {
    var hitPoints = 20
    let landAttack = true
    let landMovement = true
    
    func doLandAttack() { print("Lew atakuje.") }
    func doLandMovement() { print("Lew porusza się.") }
}

struct Alligator: LandAnimal, SeaAnimal {
    var hitPoints = 35
    let landAttack = true
    let landMovement = true
    let seaAttack = true
    let seaMovement = true
    
    func doLandAttack() { print("Aligator atakuje na lądzie.") }
    func doLandMovement() { print("Aligator porusza się na lądzie.") }
    func doSeaAttack() { print("Aligator atakuje w wodzie.") }
    func doSeaMovement() { print("Aligator porusza się w wodzie.") }
}


var animals = [Animal]()

var an1 = Alligator()
var an2 = Alligator()
var an3 = Lion()

animals.append(an1)
animals.append(an2)
animals.append(an3)


for (index, animal) in animals.enumerated() {
    if let _ = animal as? AirAnimal {
        print("Zwierzę o indeksie \(index) to powietrzne.")
    }
    if let _ = animal as? LandAnimal {
        print("Zwierzę o indeksie \(index) to lądowe.")
    }
    if let _ = animal as? SeaAnimal {
        print("Zwierzę o indeksie \(index) to wodne.")
    }
}


for (index, animal) in animals.enumerated() where animal is SeaAnimal {
    print("Tylko zwierzę wodne: \(index)")
}
